// SPDX-License-Identifier: GPL-2.0
#include <linux/seq_file.h>
#include <linux/fs.h>
#include <linux/init.h>
#include <linux/kernel_stat.h>
#include <linux/interrupt.h>
#include <linux/proc_fs.h>

#include <linux/sched/stat.h>
#include <linux/slab.h>
#include <linux/time.h>
#include <linux/time_namespace.h>
#include <linux/irqnr.h>
#include <linux/sched/cputime.h>
#include <linux/tick.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/signal.h>
// Task 1
static int show_pg_stats(struct seq_file *p, void *v)
{
        struct task_struct *process;
        for_each_process(process){
                seq_printf(p, "%d: [[%u],[%u],[%u]], [[%u],[%u],[%u]], [[%u],[%u],[%u]], [[%u],[%u],[%u]]\n",
                        process->pid,
                        process->pgd_alloc,
                        process->pgd_free,
                        process->pgd_set,
                        process->pud_alloc,
                        process->pud_free,
                        process->pud_set,
                        process->pmd_alloc,
                        process->pmd_free,
                        process->pmd_set,
                        process->pte_alloc,
                        process->pte_free,
                        process->pte_set);
        }
        return 0;
}
static int pg_stats_open(struct inode *inode, struct file *file){
	unsigned int size = 1024 + 128 * nr_processes();
	return single_open_size(file, show_pg_stats, NULL, size);
}

static const struct proc_ops pg_stats_ops = {
        .proc_flags = PROC_ENTRY_PERMANENT,
        .proc_open = pg_stats_open,
        // Default iter. We don't use an itter
        .proc_read_iter = seq_read_iter,
        .proc_lseek = seq_lseek,
        .proc_release = single_release,
};

static int __init pg_stat_init(void){
        proc_create("pg_stats", 0, NULL, &pg_stats_ops);
        return 0;
}
fs_initcall(pg_stat_init);